/* 
  Copyright (c) 1998 Further Consulting
  All rights reserved.
 
  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:
  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
  3. All advertising materials mentioning features or use of this software
     must display the following acknowledgement:
       This product includes software developed by A & A Custom Software 
       and its contributors.
  4. Neither the name of Further Consulting nor the names of its 
     contributors may be used to endorse or promote products derived from this 
     software without specific prior written permission.
 
  THIS SOFTWARE IS PROVIDED BY FURTHER CONSULTING AND CONTRIBUTORS ``AS IS''
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED.  IN NO EVENT SHALL FURTHER CONSULTING OR CONTRIBUTORS BE 
  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
  POSSIBILITY OF SUCH DAMAGE.
 
 $Header: /home/jonny/src/cvs/khylafax/khylafax/status.cpp,v 1.6 1999/03/06 18:01:54 jonny Exp $

*/

#include <qregexp.h>
#include <qframe.h>
#include <qlayout.h>
#include <kapp.h>
#include <ktopwidget.h>
#include <kwm.h>
#include <kconfig.h>
#include <kiconloader.h>
#include <qbttngrp.h>
#include <kprocess.h>
#include <kmsgbox.h>
#include "khylafax.h"
#include "status.h"
#include "prefs.h"
#include "netcom.h"

#include <iostream.h>

KHylaFaxStatus::KHylaFaxStatus(KConfig *conf,
	NetCom *netcom,
	QWidget* parent,
	const char* name
)
	:
	QDialog (parent, name, 0)
{
	this->config = conf;
	this->netcom = netcom;

	QGridLayout *statusGrid = new QGridLayout(this, 1, 1, 10);	

	// insert list-box
	
	config->setGroup("WindowSettings");
	
	listbox = new KTabListBox(this, "ListBox_1", 5);
	listbox->setGeometry(5, 5,
		config->readNumEntry("recvbox_width", 500),
		config->readNumEntry("recvbox_height", 400)
	);
	listbox->setColumn(0, klocale->translate("Pages"), config->readNumEntry("colPages", 80));
	listbox->setColumn(1, klocale->translate("Sender"), config->readNumEntry("colSender", 200));
	listbox->setColumn(2, klocale->translate("SubAddr"), config->readNumEntry("colSubAddr", 80));
	listbox->setColumn(3, klocale->translate("Date"), config->readNumEntry("colDate", 100));
	listbox->setColumn(4, klocale->translate("Filename"), config->readNumEntry("colFile", 200));
	listbox->setSeparator('|');

	statusGrid->addWidget(listbox, 1, 1);

	connect(listbox, SIGNAL(selected(int, int)), this, SLOT(selected(int, int)));
	
	// first update status
	getStatus();
}

void KHylaFaxStatus::selected(int index, int col)
{
	QString filename = listbox->text(index, 4);

	cout << "clicked on file " << filename << endl;

	QBuffer *buffer = netcom->getFile("recvq", filename);

	filename = "/tmp/" + filename;
	filename.truncate(filename.length() - 1);

	FILE *fd = fopen(filename, "w");
	fwrite(buffer->buffer(), 1, buffer->size(), fd);
	fclose(fd);

	KShellProcess proc;
	proc.setExecutable(QString("docview ") + filename);
	proc.start(KProcess::DontCare, KProcess::NoCommunication);
}

void KHylaFaxStatus::getStatus()
{
  // get the receive queue
  QList<QString> list = netcom->readDir("recvq");
  
  for(QString *s=list.first(); s!=0; s=list.next()) {
    // add entry to our listbox
    processLine(*s);
  }
  listbox->setTopItem(list.count());
}

KHylaFaxStatus::~KHylaFaxStatus()
{
}

void KHylaFaxStatus::closeEvent ( QCloseEvent *e)
{
	config->setGroup("WindowSettings");
	
	config->writeEntry("recvbox_width", listbox->width());
	config->writeEntry("recvbox_height", listbox->height());
	config->writeEntry("colPages", listbox->columnWidth(0));
	config->writeEntry("colSender", listbox->columnWidth(1));
	config->writeEntry("colSubAddr", listbox->columnWidth(2));
	config->writeEntry("colDate", listbox->columnWidth(3));
	config->writeEntry("colFile", listbox->columnWidth(4));
	
	config->sync();
	
	e->accept();	
}

void KHylaFaxStatus::processLine(const char *line)
{
  listbox->insertItem(line);
}

void KHylaFaxStatus::ReadStdout(KProcess *p, char *buffer, int buflen)
{
	QString s(buffer, buflen);
	*output += s;
}

void KHylaFaxStatus::Exited (KProcess *proc)
{
	QTextStream t(*output, IO_ReadOnly);
	while (!t.eof() )
	{
		QString s = t.readLine();
		listbox->insertItem(s);
	}
}

#include "status.moc"
